'use strict';

function BCPEstateModalCtrl($scope, $rootScope, EstatesCurrentList, EstatesList){
    var elementId = "#modal-estates-offers";

    $scope.placesList = [];
    $scope.placesToAdd = [];
    $scope.disableSave = true;
    $scope.selectedItem = false;


    $scope.$on('Estate:openEstateOffersModal', function(event, type){
        $scope.title = type.name;
        $scope.selectedItem = false;
        $scope.type = type;

        $scope.placesToAdd = [];
        $scope.placesList = [];
        EstatesList.list[type].forEach(function(item){
            var newItem = angular.copy(item);
            $scope.placesList.push(newItem);
        });

        $scope.openModal();

        setTimeout(function(){
            $scope.$apply();
            $(".nano").nanoScroller({alwaysVisible: true});
        }, 300);
    });

    $scope.checkEstateOffer = function(estate) {
        if(estate.checked){
            for (var i = 0; i < $scope.placesToAdd.length; i++) {
                if ($scope.placesToAdd[i].id === estate.id) {
                    $scope.placesToAdd.splice(i, 1);
                    break;
                }
            }
        }else if(!estate.checked){
            $scope.placesToAdd.push(estate);
        }
        estate.checked = !estate.checked;
    }

    $scope.save = function(){
        $scope.placesToAdd.forEach(function(item){
            item.checked = false;
            EstatesCurrentList.addItem(item);
        });
        $scope.closeModal();
    }

    $scope.reloadList = function(){
        var message = {
            title: 'Oferty nieruchomości'
            ,msg: 'Szukam nowych ofert nieruchomości. Proszę czekać...'
        }
        $rootScope.$broadcast('Message:addMsg', message);
        $scope.closeModal();
        $scope.placesList = [];

        EstatesList.reload(function(){
            EstatesList.list[$scope.type].forEach(function(item){
                var newItem = angular.copy(item);
                $scope.placesList.push(newItem);
            });

            $rootScope.$broadcast('Message:delMsg', message);

            setTimeout(function(){
                $scope.openModal();
            }, 300);
        });

    }

    $scope.isCompanyEstate = function(Estate){
        return EstatesCurrentList.isCompanyEstate(Estate);
    }


/*    $scope.sumOfEstate = function() {
        var sum = 0;
        var electricity = 0;
        var costs = {};
        angular.forEach($scope.placesToAdd, function(place) {
            sum += place.buy_now_price;
            electricity += (place.surface * $scope.company.user_groups.user.market_segment.energy_cost);
        });

        var CurrentAccount = BanksList.getCurrentAccount();
        if(sum > CurrentAccount.company_bank_service_options[0].value)
        {
            $scope.disableSave = true;
        }
        else
        {
            $scope.disableSave = false;
        }

        costs.sum = sum;
        costs.electricity = electricity;

        return costs;
    }*/

    $scope.openModal = function(){
        angular.element(elementId).modal('show');
    }

    $scope.closeModal = function(){
        angular.element(elementId).modal('hide');
    }
}

BCPEstateModalCtrl.$inject = ['$scope', '$rootScope', 'EstatesCurrentList', 'EstatesList'];